/*
 * This file is part of Araknemu.
 *
 * Araknemu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Araknemu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Araknemu.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2017-2019 Vincent Quatrevieux
 */

package fr.quatrevieux.araknemu.game.monster.group.generator;

import fr.quatrevieux.araknemu.data.world.repository.monster.MonsterGroupDataRepository;
import fr.quatrevieux.araknemu.game.GameBaseCase;
import fr.quatrevieux.araknemu.game.monster.Monster;
import fr.quatrevieux.araknemu.game.monster.MonsterService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.util.List;

import static org.junit.jupiter.api.Assertions.assertArrayEquals;
import static org.junit.jupiter.api.Assertions.assertEquals;

class FixedMonsterListGeneratorTest extends GameBaseCase {
    private FixedMonsterListGenerator generator;
    private MonsterGroupDataRepository repository;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();

        dataSet
            .pushMonsterTemplates()
            .pushMonsterGroups()
            .pushMonsterSpells()
        ;

        repository = container.get(MonsterGroupDataRepository.class);
        generator = new FixedMonsterListGenerator(container.get(MonsterService.class));
    }

    @Test
    void generate() {
        List<Monster> monsters = generator.generate(repository.get(1));

        assertCount(2, monsters);
        assertArrayEquals(new int[] {31, 34}, monsters.stream().mapToInt(Monster::id).toArray());
        assertBetween(2, 6, monsters.get(0).level());
        assertEquals(10, monsters.get(1).level());
    }

    @Test
    void generateShouldUseRateAsMultiplier() {
        List<Monster> monsters = generator.generate(repository.get(4));

        assertCount(6, monsters);
        assertArrayEquals(new int[] {31, 31, 34, 34, 34, 34}, monsters.stream().mapToInt(Monster::id).toArray());
    }
}
