/*
 * This file is part of Araknemu.
 *
 * Araknemu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Araknemu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Araknemu.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2017-2020 Vincent Quatrevieux
 */

package fr.quatrevieux.araknemu.game.admin.server;

import fr.quatrevieux.araknemu.core.BootException;
import fr.quatrevieux.araknemu.game.GameService;
import fr.quatrevieux.araknemu.game.admin.CommandTestCase;
import fr.quatrevieux.araknemu.game.admin.exception.AdminException;
import fr.quatrevieux.araknemu.game.fight.FightService;
import fr.quatrevieux.araknemu.game.player.PlayerService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.sql.SQLException;

class InfoTest extends CommandTestCase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();

        command = new Info(app, container.get(PlayerService.class), container.get(GameService.class), container.get(FightService.class));
    }

    @Test
    void execute() throws SQLException, AdminException, BootException {
        app.boot();
        execute("info");

        assertOutputContains("===== Server information =====");
        assertOutputContains("Online : 1 sessions and 1 players");
        assertOutputContains("Fights : 0 fights with 0 fighters");
    }

    @Test
    void help() {
        assertHelp(
            "info - Display information about the server",
            "========================================",
            "SYNOPSIS",
                "\tinfo",
            "EXAMPLES",
                "\t*info - Display server info",
            "PERMISSIONS",
                "\t[ACCESS]"
        );
    }
}
