/*
 * This file is part of Araknemu.
 *
 * Araknemu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Araknemu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Araknemu.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2017-2019 Vincent Quatrevieux
 */

package fr.quatrevieux.araknemu.network.game.out.exchange.store;

import fr.quatrevieux.araknemu.data.world.entity.item.ItemTemplate;
import fr.quatrevieux.araknemu.data.world.transformer.ItemEffectsTransformer;

import java.util.Collection;
import java.util.stream.Collectors;

/**
 * List of available item on an npc store
 *
 * https://github.com/Emudofus/Dofus/blob/1.29/dofus/aks/Exchange.as#L1043
 */
public final class NpcStoreList {
    private static final ItemEffectsTransformer effectsSerializer = new ItemEffectsTransformer();

    private final Collection<ItemTemplate> items;

    public NpcStoreList(Collection<ItemTemplate> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "EL" +
            items.stream()
                .map(template -> template.id() + ";" + effectsSerializer.serialize(template.effects()))
                .collect(Collectors.joining("|"))
        ;
    }
}
