/*
 * This file is part of Araknemu.
 *
 * Araknemu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Araknemu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Araknemu.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2017-2019 Vincent Quatrevieux
 */

package fr.quatrevieux.araknemu.game.handler.loader;

import fr.quatrevieux.araknemu.core.di.Container;
import fr.quatrevieux.araknemu.core.network.parser.PacketHandler;
import fr.quatrevieux.araknemu.game.handler.fight.ChangeFighterReadyState;
import fr.quatrevieux.araknemu.game.handler.fight.ChangeFighterStartPlace;
import fr.quatrevieux.araknemu.game.handler.fight.EndFighterTurn;
import fr.quatrevieux.araknemu.game.handler.fight.KickFighter;
import fr.quatrevieux.araknemu.game.handler.fight.ShowCell;
import fr.quatrevieux.araknemu.game.handler.fight.option.ToggleBlockSpectator;
import fr.quatrevieux.araknemu.game.handler.fight.option.ToggleLockTeam;
import fr.quatrevieux.araknemu.game.handler.fight.option.ToggleNeedHelp;
import fr.quatrevieux.araknemu.network.game.GameSession;

/**
 * Loader for fight packets
 */
public final class FightingLoader implements Loader {
    @Override
    @SuppressWarnings("unchecked")
    public PacketHandler<GameSession, ?>[] load(Container container) {
        return new PacketHandler[] {
            new ChangeFighterStartPlace(),
            new ChangeFighterReadyState(),
            new EndFighterTurn(),
            new ShowCell(),
            new KickFighter(),

            new ToggleBlockSpectator(),
            new ToggleLockTeam(),
            new ToggleNeedHelp(),
        };
    }
}
