/*
 * This file is part of Araknemu.
 *
 * Araknemu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Araknemu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Araknemu.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2017-2021 Vincent Quatrevieux
 */

package fr.quatrevieux.araknemu.game.fight.castable.effect.handler.characteristic.point;

import fr.quatrevieux.araknemu.data.constant.Characteristic;
import fr.quatrevieux.araknemu.game.fight.Fight;
import fr.quatrevieux.araknemu.game.fight.fighter.FighterData;
import fr.quatrevieux.araknemu.network.game.out.fight.action.ActionEffect;

/**
 * Apply dodgeable movement point removal effect
 */
public final class MovementPointLostApplier extends AbstractPointLostApplier {
    public MovementPointLostApplier(Fight fight) {
        this(fight, USE_SPELL_EFFECT);
    }

    /**
     * @param fight The fight where the effect should be applied
     * @param removalPointEffect Overrides the spell effect used by the buff
     */
    public MovementPointLostApplier(Fight fight, int removalPointEffect) {
        super(
            fight,
            AlterPointHook.removeMovementPoint(fight),
            Characteristic.MOVEMENT_POINT,
            Characteristic.RESISTANCE_MOVEMENT_POINT,
            removalPointEffect
        );
    }

    @Override
    protected ActionEffect dodgeMessage(FighterData caster, FighterData target, int value) {
        return ActionEffect.dodgeMovementPointLost(caster, target, value);
    }
}
