/*
 * This file is part of Araknemu.
 *
 * Araknemu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Araknemu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Araknemu.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2017-2019 Vincent Quatrevieux
 */

package fr.quatrevieux.araknemu.game.connector;

import fr.quatrevieux.araknemu.realm.host.GameHost;

/**
 * GameConnector between game server and realm server
 */
public interface RealmConnector {
    /**
     * Declare sgame host to the realm
     * @param id Server ID
     * @param port Host port
     * @param ip Host IP address
     */
    public void declare(int id, int port, String ip);

    /**
     * Update the game server state
     *
     * @param id The server ID
     * @param state The server state
     * @param canLog A player can log into server ?
     */
    public void updateState(int id, GameHost.State state, boolean canLog);
}
